require 'page-object'

class Feedback < Base
  include PageObject

  h2(:feedbackTitle, :css=>'#feedback > .primary-header h2')
  form(:feedback_form, :css=>'#feedback-form')
  button(:feedback_cancel, :css=>'#cancel-feedback')
  button(:feedback_submit, :css=>'#submit-feedback')
  elements(:feedback_rating_radio, :css=>'input[data-role="none"]')
  text_field(:feedback_comment, :css=>'#feedback-comment')
  div(:thanks_msg, :css=>'#feedback .message')
  elements(:feedback_btn, :css=>'.desktop-btns .ui-btn')
  elements(:feedback_rating_num, :css=>'.mobile-drop select[name=recommendationRating] option')
  div(:rating_section, :css=>'#rating')



  def selectFeedbackonSmallerform(feedback)
    rating_section_element.when_present(TIME_OUT_LIMIT)
    options = self.feedback_rating_num_elements
    selectOption(options, feedback)
  end

  def selectFeedbackondefullform(feedback)
    rating_section_element.when_present(TIME_OUT_LIMIT)
    options = self.feedback_btn_elements
    selectOption(options, feedback)
  end


end